<?php
// Simple PDF.js viewer wrapper (uses CDN). NOT for untrusted private files.
if ( ! defined('ABSPATH') ) {
	// If loaded directly (since it's a standalone viewer), bootstrap WP for URL constants if possible.
	// Fallback to relative assets if needed.
}
$file = isset($_GET['file']) ? $_GET['file'] : '';
$file = esc_url_raw( $file );
?><!DOCTYPE html>
<html>
<head>
<meta charset="utf-8" />
<title>sgPDF Viewer</title>
<style>
body{margin:0;font-family:system-ui,-apple-system,Segoe UI,Roboto,Ubuntu,Cantarell,"Noto Sans",sans-serif;background:#f9fafb;}
#toolbar{padding:8px;background:#111827;color:#fff;display:flex;gap:8px;align-items:center;position:sticky;top:0}
#viewerContainer{height:calc(100vh - 48px);overflow:auto}
canvas{display:block;margin:12px auto;box-shadow:0 0 0 1px #e5e7eb;border-radius:6px}
button{cursor:pointer}
</style>
</head>
<body>
<div id="toolbar">
  <span>sgPDF Viewer</span>
  <a href="<?php echo htmlspecialchars($file); ?>" target="_blank" rel="noopener" style="margin-left:auto;color:#fff;text-decoration:none">Open original</a>
</div>
<div id="viewerContainer"><canvas id="pdf-canvas"></canvas></div>

<!-- PDF.js via CDN -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdf.js/4.2.67/pdf.min.js"></script>
<script>
const url = decodeURIComponent("<?php echo rawurlencode($file); ?>");
if(!url){ document.getElementById('viewerContainer').innerHTML = '<p style="padding:20px;">No file provided.</p>'; }
else {
  const loadingTask = window['pdfjsLib'].getDocument(url);
  loadingTask.promise.then(function(pdf) {
    pdf.getPage(1).then(function(page) {
      const scale = 1.2;
      const viewport = page.getViewport({scale: scale});
      const canvas = document.getElementById('pdf-canvas');
      const context = canvas.getContext('2d');
      canvas.height = viewport.height;
      canvas.width = viewport.width;
      const renderContext = { canvasContext: context, viewport: viewport };
      page.render(renderContext);
    });
  }).catch(function(err){
    document.getElementById('viewerContainer').innerHTML = '<p style="padding:20px;color:#b91c1c;">Failed to load PDF: '+String(err)+'</p>';
  });
}
</script>
</body>
</html>
