<?php
/**
 * Plugin Name: sgPDF Manager
 * Plugin URI:  https://example.com/sgpdf-manager
 * Description: Enterprise UI document manager. Custom post type, categories & tags, uploads/imports, admin grids, CSV export, icons, filters & search, embedded viewer option, and shortcodes.
 * Version:     3.5.0
 * Author:      Saptarshi Ghosh
 * Author URI:  https://example.com
 * License:     GPLv2 or later
 * Text Domain: sgpdf-manager
 */

if ( ! defined( 'ABSPATH' ) ) exit;

define( 'SGPDFM_VERSION', '3.5.0' );
define( 'SGPDFM_PATH', plugin_dir_path( __FILE__ ) );
define( 'SGPDFM_URL',  plugin_dir_url( __FILE__ ) );

// Defaults
function sgpdfm_default_allowed_types() {
	return array(
		'application/pdf',
		'application/vnd.openxmlformats-officedocument.wordprocessingml.document',
		'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
		'application/vnd.openxmlformats-officedocument.presentationml.presentation',
		'text/plain','text/csv','application/zip'
	);
}
function sgpdfm_get_allowed_types() {
	$opt = get_option( 'sgpdfm_allowed_types', null );
	if ( ! is_array( $opt ) ) {
		$opt = sgpdfm_default_allowed_types();
		update_option( 'sgpdfm_allowed_types', $opt );
	}
	$flat = array();
	foreach ( $opt as $m ) { foreach ( array_map('trim', explode(',', $m)) as $mm ) { if ($mm) $flat[]=$mm; } }
	return array_values(array_unique($flat));
}

// Taxonomies
function sgpdfm_register_taxonomies() {
	register_taxonomy( 'sgpdf_category', array('sgpdf_doc'), array(
		'hierarchical'=>true, 'label'=>__('Doc Categories','sgpdf-manager'),
		'show_ui'=>true, 'show_admin_column'=>true, 'rewrite'=>array('slug'=>'sgpdf-category')
	));
	register_taxonomy( 'sgpdf_tag', array('sgpdf_doc'), array(
		'hierarchical'=>false, 'label'=>__('Doc Tags','sgpdf-manager'),
		'show_ui'=>true, 'show_admin_column'=>true, 'rewrite'=>array('slug'=>'sgpdf-tag')
	));
}
add_action('init','sgpdfm_register_taxonomies');

// CPT
function sgpdfm_register_cpt() {
	$labels = array('name'=>__('PDF / Documents','sgpdf-manager'),'singular_name'=>__('Document','sgpdf-manager'));
	register_post_type('sgpdf_doc', array(
		'labels'=>$labels,'public'=>false,'show_ui'=>true,'show_in_menu'=>false,
		'supports'=>array('title','thumbnail'),
		'capability_type'=>'post','map_meta_cap'=>true
	));
}
add_action('init','sgpdfm_register_cpt');

// Includes
require_once SGPDFM_PATH . 'includes/class-sgpdf-icons.php';
require_once SGPDFM_PATH . 'includes/class-sgpdf-admin.php';
require_once SGPDFM_PATH . 'includes/class-sgpdf-categories.php';
require_once SGPDFM_PATH . 'includes/class-sgpdf-docs.php';
require_once SGPDFM_PATH . 'includes/class-sgpdf-shortcodes.php';

class SGPDF_Manager {
	public function __construct() {
		add_action('admin_enqueue_scripts', array($this,'enqueue_admin'));
		add_action('wp_enqueue_scripts', array($this,'enqueue_front'));
		new SGPDF_Admin();
		new SGPDF_Categories();
		new SGPDF_Docs();
		new SGPDF_Shortcodes();
	}
	public function enqueue_admin($hook) {
		wp_register_style('sgpdfm-admin', SGPDFM_URL.'assets/admin.css', array(), SGPDFM_VERSION);
		wp_enqueue_style('sgpdfm-admin');
		wp_register_script('sgpdfm-admin', SGPDFM_URL.'assets/admin.js', array('jquery'), SGPDFM_VERSION, true);
		wp_localize_script('sgpdfm-admin','SGPDFM', array('ajax'=>admin_url('admin-ajax.php'),'nonce'=>wp_create_nonce('sgpdfm_ajax')));
		wp_enqueue_script('sgpdfm-admin');
	}
	public function enqueue_front() {
		wp_register_style('sgpdfm-front', SGPDFM_URL.'assets/front.css', array(), SGPDFM_VERSION);
		wp_enqueue_style('sgpdfm-front');
		wp_register_script('sgpdfm-front', SGPDFM_URL.'assets/front.js', array(), SGPDFM_VERSION, true);
		wp_enqueue_script('sgpdfm-front');
	}
}
new SGPDF_Manager();
