<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class SGPDF_Shortcodes {
	public function __construct() {
		add_shortcode( 'sgpdf-list', array( $this, 'render_list' ) );
		add_shortcode( 'sgpdf-columns', array( $this, 'render_columns' ) );
		add_shortcode( 'sgpdf-dropdown', array( $this, 'render_dropdown' ) );
		// BSK aliases
		add_shortcode( 'bsk-pdfm-pdfs-ul', array( $this, 'render_list' ) );
		add_shortcode( 'bsk-pdfm-pdfs-columns', array( $this, 'render_columns' ) );
		add_shortcode( 'bsk-pdfm-pdfs-dropdown', array( $this, 'render_dropdown' ) );
	}

	private function parse_ids( $ids_string ) {
		$ids = array();
		if ( ! empty( $ids_string ) ) $ids = array_filter( array_map( 'absint', explode( ',', $ids_string ) ) );
		return $ids;
	}

	private function query_docs( $ids, $category_slug = '' ) {
		$args = array(
			'post_type'=>'sgpdf_doc','post_status'=>'publish','posts_per_page'=>-1,
			'orderby'=> 'post__in'
		);
		if ( ! empty($ids) ) {
			$args['post__in'] = $ids;
		} else if ( $category_slug ) {
			$args['orderby']='date'; $args['order']='DESC';
			$args['tax_query']=array(array('taxonomy'=>'sgpdf_category','field'=>'slug','terms'=>$category_slug));
		} else {
			$args['orderby']='date'; $args['order']='DESC';
		}
		return get_posts($args);
	}

	private function file_url( $post_id ) {
		$att = intval( get_post_meta($post_id,'_sgpdf_attachment_id', true) );
		return $att ? wp_get_attachment_url($att) : '';
	}

	private function viewer_url( $file_url ) {
		$enabled = (bool) get_option('sgpdfm_enable_viewer', false);
		if ( ! $enabled ) return $file_url;
		// viewer file hosted in plugin
		return add_query_arg( array( 'file' => rawurlencode( $file_url ) ), SGPDFM_URL.'viewer/viewer.php' );
	}

	private function a_target( $target ) {
		$target = trim( (string)$target );
		return ($target==='_blank') ? ' target="_blank" rel="noopener"' : '';
	}

	public function render_list( $atts ) {
		$atts = shortcode_atts( array('id'=>'','category'=>'','target'=>'','viewer'=>'false'), $atts, 'sgpdf-list' );
		$ids = $this->parse_ids($atts['id']);
		$docs = $this->query_docs( $ids, sanitize_title($atts['category']) );
		if ( empty($docs) ) return '';
		$t = $this->a_target( $atts['target'] );
		$use_viewer = filter_var( $atts['viewer'], FILTER_VALIDATE_BOOLEAN );
		ob_start(); echo '<ul class="sgpdf-list">';
		foreach ($docs as $p) {
			$url = $this->file_url($p->ID);
			$link = $use_viewer ? $this->viewer_url( $url ) : $url;
			echo '<li>'.SGPDF_Icons::ext_badge($url).' ';
			printf('<a href="%1$s"%2$s>%3$s</a>', esc_url($link), $t, esc_html(get_the_title($p->ID)));
			echo '</li>';
		}
		echo '</ul>'; return ob_get_clean();
	}

	public function render_columns( $atts ) {
		$atts = shortcode_atts( array('id'=>'','category'=>'','columns'=>'3','target'=>'','viewer'=>'false'), $atts, 'sgpdf-columns' );
		$ids = $this->parse_ids($atts['id']);
		$docs = $this->query_docs( $ids, sanitize_title($atts['category']) );
		if ( empty($docs) ) return '';
		$cols = max(1, min(6, absint($atts['columns'])));
		$t = $this->a_target( $atts['target'] );
		$use_viewer = filter_var( $atts['viewer'], FILTER_VALIDATE_BOOLEAN );
		$style = sprintf('style="display:grid;grid-template-columns:repeat(%d,1fr);gap:12px;"', $cols );
		ob_start(); printf('<div class="sgpdf-grid" %s>', $style);
		foreach ($docs as $p) {
			$url = $this->file_url($p->ID);
			$link = $use_viewer ? $this->viewer_url( $url ) : $url;
			$mime = get_post_mime_type( intval(get_post_meta($p->ID,'_sgpdf_attachment_id', true)) );
			echo '<div class="sgpdf-grid-item" style="border:1px solid #e5e7eb;padding:10px;border-radius:8px;">';
			echo '<div class="sgpdf-doc-icon">'.SGPDF_Icons::ext_badge($url).'</div>';
			printf('<div class="sgpdf-doc-title"><a href="%1$s"%2$s>%3$s</a></div>', esc_url($link), $t, esc_html(get_the_title($p->ID)));
			printf('<div class="sgpdf-doc-mime">%s</div>', esc_html($mime) );
			echo '</div>';
		}
		echo '</div>'; return ob_get_clean();
	}

	public function render_dropdown( $atts ) {
		$atts = shortcode_atts( array('id'=>'','category'=>'','target'=>'','viewer'=>'false','placeholder'=>__('Select a document...','sgpdf-manager'),'button_text'=>__('Open','sgpdf-manager')), $atts, 'sgpdf-dropdown' );
		$ids = $this->parse_ids($atts['id']);
		$docs = $this->query_docs( $ids, sanitize_title($atts['category']) );
		if ( empty($docs) ) return '';
		$t_blank = ( trim((string)$atts['target'])==='_blank' );
		$uid = 'sgpdfdd_'.wp_generate_uuid4();
		$use_viewer = filter_var( $atts['viewer'], FILTER_VALIDATE_BOOLEAN );
		ob_start(); ?>
		<div class="sgpdf-dropdown">
			<select id="<?php echo esc_attr($uid); ?>">
				<option value=""><?php echo esc_html($atts['placeholder']); ?></option>
				<?php foreach ($docs as $p): $url = $this->file_url($p->ID); $link = $use_viewer ? $this->viewer_url($url) : $url; ?>
					<option value="<?php echo esc_url($link); ?>"><?php echo esc_html( get_the_title($p->ID) ); ?></option>
				<?php endforeach; ?>
			</select>
			<button type="button" onclick="(function(){var s=document.getElementById('<?php echo esc_js($uid); ?>'); if(!s) return; var v=s.value; if(!v) return; <?php echo $t_blank ? "window.open(v,'_blank');" : "window.location.href=v;"; ?> })();"><?php echo esc_html($atts['button_text']); ?></button>
		</div>
		<?php return ob_get_clean();
	}
}
