<?php
if ( ! defined( 'ABSPATH' ) ) exit;
class SGPDF_Icons {
	public static function ext_from_url( $url ) {
		$ext = strtoupper( pathinfo( $url, PATHINFO_EXTENSION ) );
		return $ext ? $ext : 'DOC';
	}
	public static function ext_badge( $url ) {
		$ext = self::ext_from_url( $url );
		$bg = '#e5e7eb'; $fg = '#111827';
		switch ( strtolower($ext) ) {
			case 'pdf': $bg='#fee2e2'; $fg='#991b1b'; break;
			case 'doc': case 'docx': $bg='#dbeafe'; $fg='#1e3a8a'; break;
			case 'xls': case 'xlsx': case 'csv': $bg='#dcfce7'; $fg='#065f46'; break;
			case 'ppt': case 'pptx': $bg='#ffedd5'; $fg='#9a3412'; break;
			case 'txt': $bg='#f3f4f6'; $fg='#374151'; break;
			case 'zip': $bg='#ede9fe'; $fg='#5b21b6'; break;
		}
		$style = sprintf('style="display:inline-flex;align-items:center;justify-content:center;width:40px;height:40px;border-radius:8px;background:%s;color:%s;font-weight:700;"', esc_attr($bg), esc_attr($fg) );
		return '<span '.$style.'>'.esc_html($ext).'</span>';
	}
}
