<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class SGPDF_Docs {

	public function __construct() {
		add_action('add_meta_boxes', array($this,'register_metaboxes'));
		add_action('save_post_sgpdf_doc', array($this,'save_doc'), 10, 2);
		add_filter('manage_sgpdf_doc_posts_columns', array($this,'cols'));
		add_action('manage_sgpdf_doc_posts_custom_column', array($this,'col_content'), 10, 2);
	}

	public function register_metaboxes() {
		add_meta_box('sgpdf_doc_file', __('File & Details','sgpdf-manager'), array($this,'box_file'), 'sgpdf_doc', 'normal', 'high');
		add_meta_box('sgpdf_doc_dates', __('Publish / Expiry','sgpdf-manager'), array($this,'box_dates'), 'sgpdf_doc', 'side', 'default');
	}

	public function box_file($post) {
		$att_id = intval( get_post_meta($post->ID,'_sgpdf_attachment_id', true) );
		$desc = get_post_meta($post->ID,'_sgpdf_description', true);
		$url = $att_id ? wp_get_attachment_url($att_id) : '';
		?>
		<p>
			<label><strong><?php esc_html_e('Attach File','sgpdf-manager'); ?></strong></label><br>
			<input type="hidden" id="sgpdf_attachment_id" name="sgpdf_attachment_id" value="<?php echo esc_attr($att_id); ?>" />
			<input type="text" id="sgpdf_attachment_url" class="regular-text" value="<?php echo esc_url($url); ?>" readonly />
			<button class="button" id="sgpdf_pick_media"><?php esc_html_e('Choose File','sgpdf-manager'); ?></button>
		</p>
		<p>
			<label><strong><?php esc_html_e('Description','sgpdf-manager'); ?></strong></label><br>
			<textarea name="sgpdf_description" class="large-text" rows="4"><?php echo esc_textarea($desc); ?></textarea>
		</p>
		<script>
		jQuery(function($){
			$('#sgpdf_pick_media').on('click', function(e){
				e.preventDefault();
				var frame = wp.media({ title: 'Select file', button: { text: 'Use this file' }, multiple: false });
				frame.on('select', function(){
					var att = frame.state().get('selection').first().toJSON();
					$('#sgpdf_attachment_id').val(att.id);
					$('#sgpdf_attachment_url').val(att.url);
				});
				frame.open();
			});
		});
		</script>
		<?php
	}

	public function box_dates($post) {
		$pub = esc_attr( get_post_meta($post->ID,'_sgpdf_publish_at', true) );
		$exp = esc_attr( get_post_meta($post->ID,'_sgpdf_expire_at', true) );
		?>
		<p><label><?php esc_html_e('Publish Date (Y-m-d H:i)','sgpdf-manager'); ?></label>
		<input type="text" name="sgpdf_publish_at" value="<?php echo $pub; ?>" class="regular-text" placeholder="2025-01-01 10:00" /></p>
		<p><label><?php esc_html_e('Expiry Date (Y-m-d H:i)','sgpdf-manager'); ?></label>
		<input type="text" name="sgpdf_expire_at" value="<?php echo $exp; ?>" class="regular-text" placeholder="2026-01-01 10:00" /></p>
		<?php
	}

	public function save_doc($post_id, $post) {
		if ( defined('DOING_AUTOSAVE') && DOING_AUTOSAVE ) return;
		if ( ! current_user_can('edit_post', $post_id) ) return;
		update_post_meta($post_id,'_sgpdf_attachment_id', isset($_POST['sgpdf_attachment_id']) ? intval($_POST['sgpdf_attachment_id']) : 0);
		update_post_meta($post_id,'_sgpdf_description', isset($_POST['sgpdf_description']) ? wp_kses_post($_POST['sgpdf_description']) : '');
		update_post_meta($post_id,'_sgpdf_publish_at', sanitize_text_field($_POST['sgpdf_publish_at'] ?? '') );
		update_post_meta($post_id,'_sgpdf_expire_at', sanitize_text_field($_POST['sgpdf_expire_at'] ?? '') );
	}

	public function cols($cols) {
		$cols = array(
			'cb'=>'<input type="checkbox" />',
			'title'=>__('Title'),
			'file'=>__('File'),
			'sgpdf_category'=>__('Category'),
			'sgpdf_tag'=>__('Tags'),
			'date'=>__('Date')
		);
		return $cols;
	}

	public function col_content($col, $post_id) {
		if ( $col === 'file' ) {
			$att = intval( get_post_meta($post_id,'_sgpdf_attachment_id', true) );
			if ( $att ) {
				$url = wp_get_attachment_url($att);
				echo SGPDF_Icons::ext_badge( $url ).' ';
				echo '<a href="'.esc_url($url).'" target="_blank" rel="noopener">'.esc_html( basename($url) ).'</a>';
			} else {
				esc_html_e('No file attached','sgpdf-manager');
			}
		}
	}
}
