<?php
/**
 * Plugin Name: HT5 Embedder
 * Description: Upload and embed HTML5/SCORM packages (Captivate, Storyline, iSpring, etc.) with lightbox & fullscreen support.
 * Version: 1.9.5
 * Author: Your Name
 */

if (!defined('ABSPATH')) exit;

define('HT5E_VERSION', '1.9.5');
define('HT5E_DIR', plugin_dir_path(__FILE__));
define('HT5E_URL', plugin_dir_url(__FILE__));

require_once HT5E_DIR.'includes/class-ht5-admin.php';
require_once HT5E_DIR.'includes/class-ht5-upload.php';
require_once HT5E_DIR.'includes/class-ht5-frontend.php';

class HT5E_Plugin {
    private $admin;
    private $upload;
    private $frontend;

    public function __construct() {
        add_action('init', [$this, 'register_cpt']);
        add_action('admin_menu', [$this, 'cleanup_menu'], 999);
        add_shortcode('ht5', [$this, 'shortcode']);
        add_action('admin_notices', [$this, 'activation_notice']);

        $this->admin    = new HT5E_Admin();
        $this->upload   = new HT5E_Upload();
        $this->frontend = new HT5E_Frontend();
    }

    public function register_cpt() {
        $labels = ['name'=>'HTML5 Packages','singular_name'=>'Package','menu_name'=>'HT5 Embedder'];
        register_post_type('ht5_package', [
            'labels'=>$labels,
            'public'=>false,
            'show_ui'=>true,
            'supports'=>['title'],
            'show_in_menu'=>true,
            'menu_icon'=>'dashicons-format-video'
        ]);
    }

    public function cleanup_menu() {
        $pt = 'edit.php?post_type=ht5_package';
        global $menu;
        foreach ($menu as $i=>$m) {
            if (!empty($m[2]) && $m[2]===$pt) $menu[$i][0] = 'HT5 Embedder';
        }
        remove_submenu_page($pt, 'post-new.php?post_type=ht5_package');
    }

    public function shortcode($atts) {
        $atts = shortcode_atts([
            'id'         => 0,
            'width'      => get_option('ht5e_default_width','100%'),
            'height'     => get_option('ht5e_default_height','600'),
            'mode'       => get_option('ht5e_default_mode','inline'),
            'theme'      => get_option('ht5e_default_theme','01'),
            'fullscreen' => 'true',
            'scrollbars' => 'auto',
            'button_text'=> 'Launch'
        ], $atts, 'ht5');

        $id = (int)$atts['id'];
        if (!$id) return '';
        $entry = get_post_meta($id, '_ht5e_entry_url', true);
        if (!$entry) return '';

        if ($atts['mode']==='lightbox') {
            wp_enqueue_style('ht5e-frontend');
            wp_enqueue_script('ht5e-frontend');
            return '<button class="ht5e-launch ht5e-theme-'.$atts['theme'].
                   '" data-ht5e-src="'.esc_url($entry).
                   '" data-ht5e-scroll="'.esc_attr($atts['scrollbars']).'">'.
                   esc_html($atts['button_text']).'</button>';
        }

        $iframe = '<iframe class="ht5e-iframe" src="'.esc_url($entry).'" allow="fullscreen" style="width:100%;height:100%;border:0;"></iframe>';
        return '<div class="ht5e ht5e-theme-'.$atts['theme'].'" style="max-width:'.
               esc_attr($atts['width']).';height:'.(int)$atts['height'].'px">'.$iframe.'</div>';
    }

    public function activation_notice() {
        if (get_transient('ht5e_activated')) {
            echo '<div class="notice notice-success"><p><strong>✅ HT5 Embedder activated successfully.</strong> Go to <em>HT5 Embedder → Upload HTML5</em> to start.</p></div>';
            delete_transient('ht5e_activated');
        }
    }
}
function ht5e_activate(){ set_transient('ht5e_activated', true, 30); }
register_activation_hook(__FILE__, 'ht5e_activate');
add_action('plugins_loaded', function(){ $GLOBALS['ht5e'] = new HT5E_Plugin(); });
